# Document DiagnosticReport Reference - HL7 Europe Extensions v1.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document DiagnosticReport Reference**

## Extension: Document DiagnosticReport Reference 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/extensions/StructureDefinition/composition-diagnosticReportReference | *Version*:1.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DiagnosticReportReference |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under Creative Commons public domain (CC0 1.0). | | |

This extension provides a reference to the DiagnosticReport instance that is associated with this Composition.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [Composition/comp-example](Composition-comp-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.extensions|current/StructureDefinition/composition-diagnosticReportReference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-diagnosticReportReference.csv), [Excel](StructureDefinition-composition-diagnosticReportReference.xlsx), [Schematron](StructureDefinition-composition-diagnosticReportReference.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-diagnosticReportReference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/extensions/StructureDefinition/composition-diagnosticReportReference",
  "version" : "1.2.0",
  "name" : "DiagnosticReportReference",
  "title" : "Document DiagnosticReport Reference",
  "status" : "active",
  "date" : "2025-12-19T11:52:02+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This extension provides a reference to the DiagnosticReport instance that is associated with this Composition.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under Creative Commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Document DiagnosticReport Reference",
        "definition" : "This extension provides a reference to the DiagnosticReport instance that is associated with this Composition."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/extensions/StructureDefinition/composition-diagnosticReportReference"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DiagnosticReport"]
          }
        ]
      }
    ]
  }
}

```
