# Many: Periods of Life - HL7 Europe Extensions v1.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Many: Periods of Life**

## Extension: Many: Periods of Life 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life | *Version*:1.2.0 |
| Active as of 2025-12-19 | *Computable Name*:PeriodsOfLife |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under Creative Commons public domain (CC0 1.0). | |

Extensions used to indicate a time period in a person's life as a reference to a coded value for that life period.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [Condition/condition-example](Condition-condition-example.md) and [Consent/consent-example](Consent-consent-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.extensions|current/StructureDefinition/periods-of-life)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-periods-of-life.csv), [Excel](StructureDefinition-periods-of-life.xlsx), [Schematron](StructureDefinition-periods-of-life.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "periods-of-life",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life",
  "version" : "1.2.0",
  "name" : "PeriodsOfLife",
  "title" : "Many: Periods of Life",
  "status" : "active",
  "date" : "2025-12-19T11:52:02+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "Extensions used to indicate a time period in a person's life as a reference to a coded value for that life period.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under Creative Commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Age"
    },
    {
      "type" : "element",
      "expression" : "Period"
    },
    {
      "type" : "element",
      "expression" : "Range.low"
    },
    {
      "type" : "element",
      "expression" : "Range.high"
    },
    {
      "type" : "element",
      "expression" : "dateTime"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Many: Periods of Life",
        "definition" : "Extensions used to indicate a time period in a person's life as a reference to a coded value for that life period."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/extensions/ValueSet/periods-of-life-vs"
        }
      }
    ]
  }
}

```
