# Scope and Content - HL7 Europe Extensions v1.2.0

* [**Table of Contents**](toc.md)
* **Scope and Content**

## Scope and Content

This guide sets out a collection of HL7 Europe extensions designed for applicability within the EU realm for both HL7 FHIR R4 and R5.

This includes extensions defined for HL7 Europe implementation guides, such as:

* HL7 Europe Laboratory Report
* HL7 Europe Medication Prescription and Dispense
* HL7 Europe Hospital Discharge Report
* HL7 Europe Imaging Study Report

### Purpose

This guide aims to:

* **Promote reuse** of FHIR artefacts across different European Implementation Guides and projects.
* **Avoid duplication** by complementing, rather than duplicating, existing FHIR core extensions or other widely adopted implementation guides.
* **Support harmonisation** across Member States to facilitate cross-border data exchange and EU-wide interoperability.
* **Encourage adoption beyond Europe**, contributing to globally usable solutions where appropriate.

### Content Overview

| | | |
| :--- | :--- | :--- |
| [Composition: Based On Order](StructureDefinition-composition-basedOn-order-or-requisition.md) | This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills. | Composition |
| [Composition: Information recipient](StructureDefinition-information-recipient.md) | This extension applies to the Composition resource and is used to represent an intended recipient of the composition. | Composition |
| [Consent: Related Condition](StructureDefinition-consent-relatedCondition.md) | The problem or disorder to which the living will applies. | Consent |
| [Document DiagnosticReport Reference](StructureDefinition-composition-diagnosticReportReference.md) | This extension provides a reference to the DiagnosticReport instance that is associated with this Composition. | DiagnosticReport |
| [Encounter: Legal Status](StructureDefinition-encounter-legalStatus.md) | Legal status/situation at admission. This extension may be used for representing the basis on which the patient is staying in a healthcare organisation. This can be either voluntary or involuntary. A patient can also receive healthcare based on a forensic status. (voluntary, involuntary, admission by legal authority). | Encounter |
| [Medication: Package type](StructureDefinition-medication-package-type.md) | This extension applies to Medication and expresses the type of the container for the product (e.g. bottle, unit-dose blister, pre-filled pen). | Medication |
| [Periods of Life](StructureDefinition-periods-of-life.md) | Extensions used to indicate a time period in a person's life as a reference to a coded value for that life period. | Age, Period, Range.low, Range.high |

