# Composition: example with extensions - HL7 Europe Extensions v1.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition: example with extensions**

## Example Composition: Composition: example with extensions

**Composition: Based On Order**: `http://example.org`/document-order-1

**Composition: Information recipient**: MUDr. Aleš Procházka

**Document DiagnosticReport Reference**: My Laboratory Report Test

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/7.0.1/NamingSystem-uri.html)/urn:uuid:3f69e0a5-2177-4540-baab-7a5d0877428f

**status**: Final

**type**: Laboratory report

**date**: 2022-10-25 14:30:00+0100

**author**: MUDr. Aleš Procházka

**title**: Laboratory Report Test

### Attesters

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Mode** | **Time** | **Party** |
| * | Legal | 2020-12-27 14:30:00+0100 | Best Laboratory |

**custodian**: Best Laboratory



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "comp-example",
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/StructureDefinition/composition-basedOn-order-or-requisition",
      "valueIdentifier" : {
        "system" : "http://example.org",
        "value" : "document-order-1"
      }
    },
    {
      "url" : "http://hl7.eu/fhir/StructureDefinition/information-recipient",
      "valueReference" : {
        "display" : "MUDr. Aleš Procházka"
      }
    },
    {
      "url" : "http://hl7.eu/fhir/extensions/StructureDefinition/composition-diagnosticReportReference",
      "valueReference" : {
        "display" : "My Laboratory Report Test"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:3f69e0a5-2177-4540-baab-7a5d0877428f"
    }
  ],
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11502-2",
        "display" : "Laboratory report"
      }
    ]
  },
  "subject" : [
    {
      "display" : "Nice Patient"
    }
  ],
  "date" : "2022-10-25T14:30:00+01:00",
  "author" : [
    {
      "display" : "MUDr. Aleš Procházka"
    }
  ],
  "title" : "Laboratory Report Test",
  "attester" : [
    {
      "mode" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/composition-attestation-mode",
            "code" : "legal",
            "display" : "Legal"
          }
        ]
      },
      "time" : "2020-12-27T14:30:00+01:00",
      "party" : {
        "display" : "Best Laboratory"
      }
    }
  ],
  "custodian" : {
    "display" : "Best Laboratory"
  }
}

```
