# Consent: example with extensions - HL7 Europe Extensions v1.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent: example with extensions**

## Example Consent: Consent: example with extensions



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "consent-example",
  "contained" : [
    {
      "resourceType" : "Condition",
      "id" : "condition-example",
      "clinicalStatus" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "active",
            "display" : "Active"
          }
        ]
      },
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "431855005",
            "display" : "Chronic kidney disease stage 1"
          }
        ]
      },
      "subject" : {
        "display" : "Nice Patient"
      },
      "onsetAge" : {
        "extension" : [
          {
            "url" : "http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "41847000",
                  "display" : "Adulthood"
                }
              ]
            }
          }
        ],
        "value" : 40,
        "system" : "http://unitsofmeasure.org",
        "code" : "a"
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/StructureDefinition/consent-relatedCondition",
      "valueReference" : {
        "reference" : "#condition-example"
      }
    }
  ],
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "59284-0",
          "display" : "Consent Document"
        }
      ]
    }
  ]
}

```
