# Artifacts Summary - HL7 Europe Extensions v1.2.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Composition: Based On Order](StructureDefinition-composition-basedOn-order-or-requisition.md) | This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills. |
| [Composition: Information recipient](StructureDefinition-information-recipient.md) | This extension applies to the Composition resource and is used to represent an intended recipient of the composition. |
| [Consent: Related Condition](StructureDefinition-consent-relatedCondition.md) | The problem or disorder to which the living will applies. |
| [Document DiagnosticReport Reference](StructureDefinition-composition-diagnosticReportReference.md) | This extension provides a reference to the DiagnosticReport instance that is associated with this Composition. |
| [Encounter: Legal Status](StructureDefinition-encounter-legalStatus.md) | Legal status/situation at admission. This extension may be used for representing the basis on which the patient is staying in a healthcare organisation. This can be either voluntary or involuntary. A patient can also receive healthcare based on a forensic status. (voluntary, involuntary, admission by legal authority). |
| [Many: Periods of Life](StructureDefinition-periods-of-life.md) | Extensions used to indicate a time period in a person's life as a reference to a coded value for that life period. |
| [Medication: Package type](StructureDefinition-medication-package-type.md) | This extension applies to Medication and expresses the type of the container for the product (e.g. bottle, unit-dose blister, pre-filled pen). |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Example of Legal Status at admission Value Set](ValueSet-example-legal-status-vs.md) | This is an example value set representing the Legal status / Situation at admission. |
| [Periods of Life Value Set](ValueSet-periods-of-life-vs.md) | A value set of periods of life extension ([SNOMED tree](https://browser.ihtsdotools.org/?perspective=full&conceptId1=767023003&edition=MAIN/2025-04-01&release=&languages=en)). |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Composition: example with extensions](Composition-comp-example.md) | Example of Composition with InformationRecipient and CompositionBasedOnOrderOrRequisition extensions. |
| [Condition: example with extensions](Condition-condition-example.md) | Example of Condition with periodOfLife extensions. |
| [Consent: example with extensions](Consent-consent-example.md) | Example of Consent with related condition. |
| [Encounter: example with extensions.](Encounter-enc-example.md) | Example of Encounter with legal status. |
| [Medication: example with extensions.](Medication-04A-FirmagonBranded.md) | Example of Medication resource implementing the MPD extensions documented in this guide. |

