# hl7.fhir.eu.extensions#1.2.0: HL7 Europe Extensions

## Pages

* [Home](index.md)
* [Artifacts Summary](artifacts.md)
* [Authors and Contributors](authors.md)
* [Change Log](changes.md)
* [Copyright](copyright.md)
* [Cross-version Analysis](crossversionanalysis.md)
* [Dependencies](dependencies.md)
* [Design Choices](design.md)
* [Downloads](downloads.md)
* [Known Issues](knownissues.md)
* [Scope and Content](scope.md)

## Resources

### ValueSets

* [Example of Legal Status at admission Value Set](ValueSet-example-legal-status-vs.md)
* [Periods of Life Value Set](ValueSet-periods-of-life-vs.md)

### Extensions

* [Composition: Based On Order](StructureDefinition-composition-basedOn-order-or-requisition.md)
* [Document DiagnosticReport Reference](StructureDefinition-composition-diagnosticReportReference.md)
* [Consent: Related Condition](StructureDefinition-consent-relatedCondition.md)
* [Encounter: Legal Status](StructureDefinition-encounter-legalStatus.md)
* [Composition: Information recipient](StructureDefinition-information-recipient.md)
* [Medication: Package type](StructureDefinition-medication-package-type.md)
* [Many: Periods of Life](StructureDefinition-periods-of-life.md)

### ImplementationGuides

* [HL7 Europe Extensions](index.md)

### Examples

* [Laboratory Report Test (Composition)](Composition-comp-example.md)
* [condition-example (Condition)](Condition-condition-example.md)
* [consent-example (Consent)](Consent-consent-example.md)
* [enc-example (Encounter)](Encounter-enc-example.md)
* [04A-FirmagonBranded (Medication)](Medication-04A-FirmagonBranded.md)
