# Home - xShare Project IPS+ v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xshare-ips-plus/ImplementationGuide/hl7.eu.fhir.xshare-ips-plus | *Version*:0.1.0 |
| Draft as of 2025-10-14 | *Computable Name*:XshareipsplusIg |

> The specification herewith documented is a working specification. No liability can be inferred from the use or misuse of this specification, or its consequences.

### Scope

 This guide provides instructions to help you understand and implement your product in accordance with the **xShare IPS+**, facilitating in the access and adoption of the selected specifications. 

### Purpose

 This FHIR Implementation guide is designed to assist users in implementing the International Patient Summary for secondary data purposes, such as clinical research and public health. The xShare specification informs the FHIR International Patient Summary and this is referred to as IPS+. The aim is to solve the existing challenge created by the variability and semantic differences in health data. Addressing this issue successfully will help create a consistent and reliable health data system, improving public health and wellness and to enable clinical research, the results of which can inform healthcare decisions in a learning health system. It will also give individuals greater control over their own health data and support seamless data exchange for both primary and secondary use. 

 The overarching purpose of this guide is to outline how to use the International Patient Summary for secondary data purposes, such as clinical research and public health. This will improve the usability, the quality, and the timing of the data availability for these purposes. It is important to use secondary data efficiently to improve processes and reduce documentation burden. This guide provides detailed instructions for implementing business use cases, interoperability specifications aligned with international standards, and a standardized core data element set for use across healthcare, population health, and clinical research. To ensure consistency with existing terminologies, we include preferred value sets and code lists. 

 This FHIR Implementation Guide is primarily in the form of downloadable informational materials, spreadsheets, mappings and documents to aid functionalities related to the xShare Yellow Button in support of secondary data use. 

 More specifically, the purpose of this FHIR IG is as follows: 

*  this document specifies the representation of the data elements utilising the HL7 FHIR Implementation Guide for the IPS+, incorporating the minimal additional data elements that will enhance secondary use. 
*  this document provides the mappings of terminological concepts and value domains to SNOMED CT. It also provides the detailed correspondence of the data elements names and value domains to CDISC SDTM. These mappings are required because the use cases connect the domains of clinical research and healthcare, which (historically and currently) utilise different standards. Clinical trial critical eligibility criteria and research datasets and analysis files are likely to be expressed using CDISC standards or could readily be mapped to them. 
*  any party seeking to transform queries containing clinical trial eligibility criteria will therefore need to perform this mapping from CDISC to HL7 FHIR and SNOMED. Similarly, any parties seeking to utilise a patient’s IPS+ within a clinical trial will need to perform the mapping in the other direction to generate CDISC data sets. 

### How to read

 The content of this guide is organized following the BDAT (business, data, application, and technology) model, as illustrated in the figure below. 

Fig. 1: Navigating this guide

Where: 

*  The [**business domain**](https://build.fhir.org/ig/hl7-eu/xshare-ips+/business.html) describes the business rationale of the use cases in clinical research that rely on the IPS+. 
*  The [**application domain**](https://build.fhir.org/ig/hl7-eu/xshare-ips+/application.html) describes three use cases in clinical research in detail. 
*  The [**data domain**](https://build.fhir.org/ig/hl7-eu/xshare-ips+/content.html) describes the IPS+ data model. 
*  The [**technology domain**](https://build.fhir.org/ig/hl7-eu/xshare-ips+/technical.html) describes the technology stack, the use cases flow referencing the infrastructure components required to support these use cases. 

