# IPS+ Business overview - xShare Project IPS+ v0.1.0

* [**Table of Contents**](toc.md)
* **IPS+ Business overview**

## IPS+ Business overview

The **business domain** describes the overview and business use cases in research that will rely on the IPS+.

### Overview

In clinical research, the IPS+ can be used to assess study and protocol feasibility by ensuring sites have a sufficient patient population that meets the eligibility criteria as defined in the inclusion and exclusion criteria. It also aids in patient pre-screening by allowing patients who believe they might be eligible to share their data with potential study sites. Additionally, it supports the conduct of the study by enabling the transfer of data from EHRs/PHRs to Study Database Systems or EDC systems, which eliminates data duplication and improves data quality by avoiding content re-entry into an additional source and reduce burden on study sites personnel.

### Business Use Cases

The user stories emphasize the importance of patients being active participants in this process, by triggering the use case, through data sharing in accordance with GDPR portability rights. They also emphasize the need for follow-up after data sharing until effective inclusion in a clinical trial. The xShare Yellow Button data sharing functionality would benefit from a toggle feature, allowing patients to control their health data sharing.

For the research team and clinical investigators, efficient, relevant data sharing is crucial to streamline processes, minimize screen failures and save time.

Patients would benefit by receiving feedback regarding their potential eligibility for a clinical trial through communication between the pre-screening tool and any application used by the patient to submit their enquiry, including compatible clinical trials and their locations. Location details help patients choose a hospital based on their preferences. For example, a patient participating in a prospective observational or a retrospective study would prefer a nearby hospital, while a patient seeking innovative drug treatment for an untreatable condition might be willing to travel further. For patients participating in clinical trials, this allows improved patient safety and for patients in general, faster access to new medications.

It is recognised that patients can benefit from being able to access and possibly download an identifiable data copy of the data captured during their trial participation, which goes beyond the scope of the IPS+ by covering a much wider range of data elements, sometimes quite specialised disease specific ones. This functionality is beyond the scope of this project, but is being tackled by other European projects, in particular [IHI Facilitate](https://facilitate-project.eu/).

The business use cases summarised in the application section, focus on clinical research. The design of IPS+ and the data specification reported here additionally supports public health use cases and use in tackling cross-border health threats such as a future pandemic. The implementation of those use cases, including if they will utilise identifiable data for contract tracing or anonymised data for population surveillance, are beyond the scope of this implementation guide.

