# Home - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/ImplementationGuide/hl7.fhir.eu.base-r5 | *Version*:0.1.0 |
| Active as of 2025-10-16 | *Computable Name*:Hl7EuBaseIg |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | |

**Acknowledgment**

The development of this Implementation Guide version has been supported by the
**Xt-EHR Joint Action**. Xt-EHR provided expertise, alignment with European health policy priorities, and validation of specifications to enable consistency with EHDS requirements.

### Scope

This Implementation Guide (IG) brings together **base** and **core** HL7® FHIR® artifacts designed specifically for the European context.

It provides a foundation for interoperability, ensuring reusability across national projects, European initiatives, and derived HL7 Europe guides.

The guide supports:

* Developers and implementers who need common building blocks.
* Policymakers and program leads who require consistent definitions for EHDS-aligned projects.
* Standards experts who wish to build on a harmonized European foundation.

### Introduction

The HL7 Europe Base and Core Implementation Guide provides a **layered approach to FHIR interoperability** in the European context; and it aims to support a coherent and reusable set of FHIR specifications across Europe.

It includes:

* **Base profiles.** Loosely constrained baseline definitions of common European concepts (e.g., Patient, Practitioner). They provide flexibility and serve as the foundation for Core and derived profiles.
* **Core profiles.** More constrained profiles designed for reuse across most European IGs. They introduce essential constraints, can often be used directly, and pursue alignment with IPS.

See the [**Introduction**page](introduction.md) for detailed explanations of Base and Core profiles, their relationship with Extensions and scoped IGs, and their alignment with EHDS and IPS.

**Fig. 1 - European Base and Core profiles**

### Guide Publication

This guide is published for two HL7 FHIR versions:

* **HL7 FHIR R4 Base IG** (hl7.fhir.eu.base). Published at [this link](https://hl7.eu/fhir/base).
* **HL7 FHIR R5 Base IG** (hl7.fhir.eu.base-r5). This Guide.

Both versions are maintained by HL7 Europe and evolve based on community feedback and EHDS requirements.

