# hl7.fhir.eu.base-r5#0.1.0: HL7 Europe Base and Core FHIR IG

## Pages

* [Home](index.md)
* [Artifacts Summary](artifacts.md)
* [Authors and Contributors](authors.md)
* [Change Log](changes.md)
* [Copyright](copyright.md)
* [Cross-version Analysis](crossversionanalysis.md)
* [Dependencies](dependencies.md)
* [Downloads](downloads.md)
* [Introduction](introduction.md)
* [Known Issues](knownissues.md)
* [Logical Models](logicalmodels.md)
* [Handling Missing Data](missing-data.md)
* [Model Map](modelmap.md)

## Resources

### ValueSets

* [Body Structure Laterality](ValueSet-siteLaterality-eu.md)
* [Body Structure Qualifier](ValueSet-siteQualifier-eu.md)
* [Types of species](ValueSet-speciesType-eu.md)

### Complex-type Profiles

* [Address (EU)](StructureDefinition-Address-eu.md)

### Resource Profiles

* [BodyStructure (EU core)](StructureDefinition-bodyStructure-eu-core.md)
* [Location (EU core)](StructureDefinition-location-eu-core.md)
* [Organization (EU core)](StructureDefinition-organization-eu-core.md)
* [Organization (EU base)](StructureDefinition-organization-eu.md)
* [Patient: Animal (EU core)](StructureDefinition-patient-animal-eu-core.md)
* [Patient (EU core)](StructureDefinition-patient-eu-core.md)
* [Patient (EU base)](StructureDefinition-patient-eu.md)
* [Practitioner (EU core)](StructureDefinition-practitioner-eu-core.md)
* [Practitioner (EU base)](StructureDefinition-practitioner-eu.md)
* [PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md)
* [PractitionerRole (EU base)](StructureDefinition-practitionerRole-eu.md)

### ImplementationGuides

* [HL7 Europe Base and Core FHIR IG](index.md)

### Examples

* [example-body-structure-eu (BodyStructure)](BodyStructure-example-body-structure-eu.md)
* [Best Location (Location)](Location-example-location.md)
* [Example Health Organization (Organization)](Organization-organization-eu-core-example.md)
* [Patient-animal-example (Patient)](Patient-Patient-animal-example.md)
* [patient-eu-core-example (Patient)](Patient-patient-eu-core-example.md)
* [practitioner-eu-core-example (Practitioner)](Practitioner-practitioner-eu-core-example.md)
* [practitionerRole-eu-core-example (PractitionerRole)](PractitionerRole-practitionerRole-eu-core-example.md)
